﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP.CRS.BLL;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
namespace VIRP_WEB.Custom.EFR
{
    public partial class Survey2012 : EfrBasePage
    {
        bool hasReferral = false;
        int bioWkfCaseTypeId = 0;
        int fragWkfCaseTypeId = 0;
        string userId = "";
        int registryId = 0;
        int surveyId = 0;

        VIRP.CRS.BO.WKF_CASE_ACTIVITY wca = new VIRP.CRS.BO.WKF_CASE_ACTIVITY();
        VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT questionnaire = new VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT();
        VIRP.EFR.BO.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM fragKit = new VIRP.EFR.BO.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM();
        VIRP.CRS.BO.WKF_CASE wc = new VIRP.CRS.BO.WKF_CASE();
        VIRP.CRS.BO.REFERRAL r = new VIRP.CRS.BO.REFERRAL();
        VIRP.CRS.BO.REFERRAL_REG rr = new VIRP.CRS.BO.REFERRAL_REG();

        private static IReadOnlyList<string> navigationSources = new List<string>
    {
        "/Custom/EFR/Questionnaires/Surveys.aspx",
        "/Custom/EFR/Questionnaires/SurveyLink.aspx",
        "/Custom/EFR/Patients/PatientWorkflows.aspx"
    };

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                string pageTitle = "My Tasks > Questionnaires/Forms";
                
                if (SetPageVars())
                { 
                    userId = HttpContext.Current.User.Identity.Name;
                    registryId = UserSession.CurrentRegistryId;

                    wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);

                    if (wca != null)
                    {
                        if (wca.STD_WKFACTIVITYSTS_ID == 1)
                            pageTitle += " > In Process > Workflow ID " + wca.WKF_CASE_ID;
                        else if (wca.STD_WKFACTIVITYSTS_ID == 2)
                            pageTitle += " > Completed > Workflow ID " + wca.WKF_CASE_ID;
                        else
                            pageTitle += " > New > Workflow ID " + wca.WKF_CASE_ID;

                        ((Label)Master.FindControl("EfrPageTitle")).Text = pageTitle;

                        wc = VIRP.CRS.BLL.WKF_CASEManager.GetItem(userId, registryId, wca.WKF_CASE_ID);

                        if (wc.REFERRAL_ID.HasValue)
                {
                            r = VIRP.CRS.BLL.REFERRALManager.GetItem(userId, registryId, (int)wc.REFERRAL_ID);
                            hasReferral = true;
                        }
                    }

                    SetStdWkfCaseTypeIds();

                    SetRadioDefaults();
                    LoadDropDownData();
                    RefreshVAMCListAndSelectInstitution();

                    if (wc.STD_WKFCASETYPE_ID == bioWkfCaseTypeId)
                    {
                        SetupBioSurvey();
                    }
                    else if (wc.STD_WKFCASETYPE_ID == fragWkfCaseTypeId)
                    {
                        SetupFragmentsSurvey();
                    }
                }

                //string referrer = Request.UrlReferrer.PathAndQuery;
                //ViewState["referrer"] = referrer;
                ViewState["referrer"] = Request.UrlReferrer;
                BindPatientData();
            }

            SetUpFinishButton();

            CompletionDateValidator.DataBind();
        }

        protected void BindPatientData()
        {
            ObjectDataPatient.SelectParameters["CURRENT_USER"].DefaultValue = userId;
            ObjectDataPatient.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = registryId.ToString();
            ObjectDataPatient.SelectParameters["PATIENT_ID"].DefaultValue = wc.PATIENT_ID.ToString();
        }
        protected void SetStdWkfCaseTypeIds()
        {
            List<VIRP.CRS.BO.STD_WKFCASETYPE> lCaseType = STD_WKFCASETYPEManager.GetItems(userId, registryId);
            foreach (VIRP.CRS.BO.STD_WKFCASETYPE ct in lCaseType)
            {
                if (ct.CODE == "BIOLOGICAL MONITORING")
                {
                    bioWkfCaseTypeId = ct.ID;
                }
                else if (ct.CODE == "FRAGMENT ANALYSIS")
                {
                    fragWkfCaseTypeId = ct.ID;
                }
            }
        }
        protected override void OnLoadComplete(EventArgs e)
        {
            //do not show complete(finish page) for complete questionnaires
            if (wca.STD_WKFACTIVITYSTS_ID == 2) 
            {
                if (FragmentsSurveyWizard.ActiveStep.ID.Equals("FacilityContactPhoneQuestion"))
                {
                    Button buttonFirstSave = FragmentsSurveyWizard.FindControl("StepNavigationTemplateContainerID").FindControl("StepNext") as Button;
                    if (buttonFirstSave != null)
                    {
                        buttonFirstSave.Enabled = false;
                    }
                }
                else
                {
                    Button buttonFirstSave = FragmentsSurveyWizard.FindControl("StepNavigationTemplateContainerID").FindControl("StepNext") as Button;
                    if (buttonFirstSave != null)
                    {
                        buttonFirstSave.Enabled = true;
                    }
                }
            }

            base.OnLoadComplete(e);
        }

        private void RefreshVAMCListAndSelectInstitution()
        {
            VAMCFAcilityNamesListBox.Items.Clear();
            VAMCFAcilityNamesListBox.Items.Add(new ListItem("(Please select institution)", "0"));
            VAMCFAcilityNamesListBox.Items.AddRange(Helpers.GetInsitutionList(userId, registryId).Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());
        }

        private void SetRadioDefaults()
        {
            BulletInjuryButtonList.SelectedIndex = 2;
            BlastExplosionButtonList.SelectedIndex = 2;
            VehicleInjuryButtonList.SelectedIndex = 2;
            SurgeryButtonList.SelectedIndex = 3;
            FragmentButtonList.SelectedIndex = 3;
            AnalysisButtonList.SelectedIndex = 3;
            RadioButtonListOccupationMetalDust.SelectedIndex = 2;
            RadioButtonListHobbyMetalDust.SelectedIndex = 2;
            RadioButtonListWaterSource.SelectedIndex = 2;
            RadioButtonListSmoke.SelectedIndex = 2;
            RadioButtonListChewTobacco.SelectedIndex = 2;
        }

        private void SetUpFinishButton()
        {
            switch (wca.STD_WKFACTIVITYSTS_ID) 
            {
                case 6:

                    break;

                case 1:

                    break;

                case 2:

                    if (BiologicalSurveyWizard.Visible == true)
                    {
                        Button buttonComplete = BiologicalSurveyWizard.FindControl("FinishNavigationTemplateContainerID").FindControl("StepFinish") as Button;
                        if (buttonComplete != null)
                        {
                            buttonComplete.Text = "Complete Questionnaire";
                            buttonComplete.Click -= CompleteBioSurvey_Click;
                            buttonComplete.Click += SaveBioSurvey_Click;
                        }
                    }
                    else
                    {
                        Button buttonComplete = FragmentsSurveyWizard.FindControl("FinishNavigationTemplateContainerID").FindControl("StepFinish") as Button;
                        if (buttonComplete != null)
                        {
                            buttonComplete.Text = "Complete Questionnaire";
                            buttonComplete.Click -= CompleteFragSurvey_Click;
                            buttonComplete.Click += SaveFragSurvey_Click;
                        }
                    }
                    break;
            }
        }
        private void SetupBioSurvey()
        {
            //set visibility, only show bio questionnaire

            BiologicalSurveyWizard.Visible = true;
            FragmentsSurveyWizard.Visible = false;
            PanelQuestionnaires.GroupingText = "&nbsp;Biological Monitoring Specimen Collection Kit Questionnaire (August 2012 Version)&nbsp;";

            //QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit;

            switch (wca.STD_WKFACTIVITYSTS_ID)
            {
                case 6:
                    rr = REFERRAL_REGManager.GetItem(userId, registryId, (int)wc.REFERRAL_ID);
                    r = VIRP.CRS.BLL.REFERRALManager.GetItem(userId, registryId, (int)wc.REFERRAL_ID);
                    VIRP.CRS.BO.STD_INSTITUTION si = new VIRP.CRS.BO.STD_INSTITUTION();

                    //prepopulate new questionnaire
                    if (r.STD_INSTITUTION_ID.HasValue)
                    {
                        si = STD_INSTITUTIONManager.GetItemComplete(userId, registryId, (int)r.STD_INSTITUTION_ID);
                        VAMCFAcilityNamesListBox.SelectedValue = r.STD_INSTITUTION_ID.ToString();
                        VAMCNameTextBox.Text = si.NAME; 
                    }

                    if (string.IsNullOrEmpty(rr.ADDRESS_LINE1)) 
                    {
                        if (string.IsNullOrEmpty(si.MAILINGADDRESSLINE1)) 
                        {
                            VAMCAddress1TextBox.Text = si.STREETADDRESSLINE1; 
                            VAMCAddress2TextBox.Text = si.STREETADDRESSLINE2;
                            VAMCAddress3TextBox.Text = si.STREETADDRESSLINE3; 
                            VAMCCityTextBox.Text = si.STREETCITY; 
                            if (si.STREETSTATE_ID.HasValue) 
                            {
                                VAMCStateTextBox.Text = si.STREETSTATE.POSTALNAME;
                            }
                            if (!String.IsNullOrEmpty(si.STREETPOSTALCODE)) 
                            {
                                if (si.STREETPOSTALCODE.IndexOf('-') > -1) 
                                {
                                    var zip = si.STREETPOSTALCODE.Split('-');

                                    VAMCZipTextBox.Text = zip[0];
                                    VAMCZip4TextBox.Text = zip[1];
                                }
                                else
                                {
                                    VAMCZipTextBox.Text = si.MAILINGPOSTALCODE; 
                                }
                            }
                        }
                        else
                        {
                            VAMCAddress1TextBox.Text = si.MAILINGADDRESSLINE1;
                            VAMCAddress2TextBox.Text = si.MAILINGADDRESSLINE2;
                            VAMCAddress3TextBox.Text = si.MAILINGADDRESSLINE3;
                            VAMCCityTextBox.Text = si.MAILINGCITY;
                            if (si.MAILINGSTATE_ID.HasValue)
                            {
                                VAMCStateTextBox.Text = si.STREETSTATE.POSTALNAME; 
                            }
                            if (!String.IsNullOrEmpty(si.MAILINGPOSTALCODE))
                            {
                                if (si.MAILINGPOSTALCODE.IndexOf('-') > -1)
                                {
                                    var zip = si.MAILINGPOSTALCODE.Split('-');

                                    VAMCZipTextBox.Text = zip[0];
                                    VAMCZip4TextBox.Text = zip[1];
                                }
                                else
                                {
                                    VAMCZipTextBox.Text = si.MAILINGPOSTALCODE;
                                }
                            }
                        }
                    }
                    else
                    {
                        VAMCAddress1TextBox.Text = rr.ADDRESS_LINE1;
                        VAMCAddress2TextBox.Text = rr.ADDRESS_LINE2;
                        VAMCAddress3TextBox.Text = rr.ADDRESS_LINE3;
                        VAMCCityTextBox.Text = rr.CITY;
                        VAMCStateTextBox.Text = rr.STATE;
                        if (!String.IsNullOrEmpty(rr.POSTAL_CODE))
                        {
                            if (rr.POSTAL_CODE.IndexOf('-') > -1)
                            {
                                var zip = rr.POSTAL_CODE.Split('-');

                                VAMCZipTextBox.Text = zip[0];
                                VAMCZip4TextBox.Text = zip[1];
                            }
                            else
                            {
                                VAMCZipTextBox.Text = rr.POSTAL_CODE;
                            }
                        }
                    }

                    break;

                case 1:
                    //in-process questionnaire - populate with previously saved data
                    questionnaire = QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);

                        SetupSavedOrCompleteSurvey(questionnaire);
                        SetupBodyPartsCheckList(questionnaire);
                        SetupBodyFragmentsCheckList(questionnaire);
                        SetupExplosionCause(questionnaire);
                    break;

                case 2:
                    //completed questionnaire

                    questionnaire = QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);

                        SetupSavedOrCompleteSurvey(questionnaire);
                        SetupBodyPartsCheckList(questionnaire);
                        SetupBodyFragmentsCheckList(questionnaire);
                        SetupExplosionCause(questionnaire);

                    break;
            }
        }

        private void SetupFragmentsSurvey()
        {
            BiologicalSurveyWizard.Visible = false;
            FragmentsSurveyWizard.Visible = true;
            PanelQuestionnaires.GroupingText = "&nbsp;Fragment Collection Kit Form Details&nbsp;";

            switch (wca.STD_WKFACTIVITYSTS_ID)
            {
                case 6:
                    if (hasReferral)
                    {
                        if (r.STD_INSTITUTION_ID.HasValue)
                            VAMCFacilityNameList.SelectedValue = r.STD_INSTITUTION_ID.Value.ToString();
                        VAMCFragAddress1TextBox.Text = rr.ADDRESS_LINE1;                        
                        VAMCFragAddress2TextBox.Text = rr.ADDRESS_LINE2;                        
                        VAMCFragAddress3TextBox.Text = rr.ADDRESS_LINE3;                        
                        VAMCFragCityTextBox.Text = rr.CITY;                        
                        VAMCFragStateTextBox.Text = rr.STATE;

                        if (!String.IsNullOrEmpty(rr.POSTAL_CODE))
                        {
                            if (rr.POSTAL_CODE.IndexOf('-') > -1)
                            {
                                var zip = rr.POSTAL_CODE.Split('-');
                                VAMCFragZipTextBox.Text = zip[0];
                                VAMCFragZip4TextBox.Text = zip[1];
                            }
                            else
                            {
                                VAMCFragZipTextBox.Text = rr.POSTAL_CODE;
                            }
                        }

                        VAMCFragMailStopTextBox.Text = String.Empty;
                    }
                    break;

                case 1:

                    fragKit = VIRP.EFR.BLL.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);

                        SetupSavedOrCompleteFragSurvey(fragKit);
                    break;
                case 2:

                    fragKit = VIRP.EFR.BLL.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);

                        SetupSavedOrCompleteFragSurvey(fragKit);

                    Button buttonComplete = FragmentsSurveyWizard.FindControl("FinishNavigationTemplateContainerID").FindControl("StepFinish") as Button;
                    if (buttonComplete != null)
                    {
                        buttonComplete.Enabled = false;
                    }

                    break;
            }
        }

        protected void BioWizard_StepChanged(object sender, EventArgs e)
        {
            Label label = BiologicalSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
            if (label != null)
            {
                label.Text = String.Empty;
            }
        }

        protected void BioWizard_Next(object sender, WizardNavigationEventArgs e)
        {
            HiddenFieldNextQuesion.Value = "1";
        }

        protected void FragWizard_StepChanged(object sender, EventArgs e)
        {
            Label label = FragmentsSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
            if (label != null)
            {
                label.Text = String.Empty;
            }
        }

        protected void FragWizard_Next(object sender, WizardNavigationEventArgs e)
        {
            HiddenFieldNextQuesion.Value = "1";
        }

        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
        }

        protected void SaveFragSurvey_Click(object sender, EventArgs e)
        {
            SetPageVars();
            wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);
            if (wca.STD_WKFACTIVITYSTS_ID != 2)
            {
                wca.STD_WKFACTIVITYSTS_ID = 1;
            }
            SaveCompleteFragSurvey();

            Label label = FragmentsSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
            if (label != null)
            {
                label.Text = "The form has been saved successfully.";
            }

            SetupFragmentsSurvey();
        }

        protected void CompleteFragSurvey_Click(object sender, EventArgs e)
        {
            SetPageVars();
            wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);
            wca.STD_WKFACTIVITYSTS_ID = 2;
            FragmentsSurveyWizard.ActiveStepIndex = 0;

            SaveCompleteFragSurvey();

            Label label = FragmentsSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
            if (label != null)
            {
                label.Text = "The form has been saved and completed successfully.";
            }

            SetupFragmentsSurvey();
        }

        protected bool SetPageVars()
        {
            bool retValue = false;
            if (int.TryParse(Request.QueryString["activityId"], out surveyId))
            {
                userId = HttpContext.Current.User.Identity.Name;
                registryId = UserSession.CurrentRegistryId;
                retValue = true;
            }

            return retValue;
        }
        protected void SaveBioSurvey_Click(object sender, EventArgs e)
        {
            SetPageVars();
            wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);
            if (wca.STD_WKFACTIVITYSTS_ID != 2)
            {
                wca.STD_WKFACTIVITYSTS_ID = 1;
            }

            SaveCompleteBioSurvey();

            Label label = BiologicalSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
            if (label != null)
            {
                label.Text = "The form has been saved successfully.";
            }

            SetupBioSurvey();
        }

        protected void CompleteBioSurvey_Click(object sender, EventArgs e)
        {
            SetPageVars();
            wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);
            wca.STD_WKFACTIVITYSTS_ID = 2;
            BiologicalSurveyWizard.ActiveStepIndex = 0;

            SaveCompleteBioSurvey();

            Label label = BiologicalSurveyWizard.FindControl("HeaderContainer").FindControl("labelAlert") as Label;
            if (label != null)
            {
                label.Text = "The form has been saved and completed successfully.";
            }

            SetupBioSurvey();
        }

        protected void BackSurvey_Click(object sender, EventArgs e)
        {
            //Response.Redirect(ViewState["referrer"].ToString());
            Uri from = ViewState["referrer"] as Uri;
            if (from != null && navigationSources.Contains(from.LocalPath))
                Response.Redirect(from.PathAndQuery);
        }

        private void SaveCompleteFragSurvey()
        {
            VIRP.EFR.BO.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM fragKit = QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);

            if (fragKit != null) // (activity.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs.Count > 0)
            {
                SetupSaveFragQuestionnaire(ref fragKit);
            }
            else
            {
                fragKit = new QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM();

                SetupSaveFragQuestionnaire(ref fragKit);

                fragKit.WKF_CASE_ACTIVITY_ID = wca.WKF_CASE_ACTIVITY_ID;
            }
            //set questionnaire in-process status
            QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.Save(userId, registryId, fragKit);
            
            WKF_CASE_ACTIVITYManager.Save(userId, registryId, wca);
        }

        private void SaveCompleteBioSurvey()
        {
            QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit = QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);

            if (bioKit != null) 
            {
                SetupSaveQuestionnaire(ref bioKit);
            }
            else
            {
                bioKit = new QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT();
                SetupSaveQuestionnaire(ref bioKit);
                bioKit.WKF_CASE_ACTIVITY_ID = wca.WKF_CASE_ACTIVITY_ID;
            }

            //set questionnaire in-process status

            QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.Save(userId, registryId, bioKit);

            WKF_CASE_ACTIVITYManager.Save(userId, registryId, wca);
        }
        private void LoadDropDownData()
        {
            //bio 
            if (wc.STD_WKFCASETYPE_ID == bioWkfCaseTypeId) 
            {
                DaysListBox.Items.Clear();
                DaysListBox.Items.AddRange(QuestionnnaireManager.GetMonthDays().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

                MonthsListBox.Items.Clear();
                MonthsListBox.Items.AddRange(QuestionnnaireManager.GetMonthNames().Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());
            }
            else //frag questionnaire
            {
                FragILListBox.Items.Clear();
                FragILListBox.Items.Add(new ListItem("(Please select location)", "0"));
                FragILListBox.Items.AddRange(QuestionnnaireManager.GetInjuryLocationList(userId, registryId).Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

                VAMCFacilityNameList.Items.Clear();
                VAMCFacilityNameList.Items.Add(new ListItem("(Please select institution)", "0"));
                VAMCFacilityNameList.Items.AddRange(Helpers.GetInsitutionList(userId, registryId).Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());
            }
        }

        private void SetupSavedOrCompleteFragSurvey(VIRP.EFR.BO.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM kit)
        {
            Frag1LocationTextBox.Text = kit.Fragment_1_Location;
            Frag2LocationTextBox.Text = kit.Fragment_2_Location;
            Frag3LocationTextBox.Text = kit.Fragment_3_Location;

            if (kit.Date_Fragment_Removal.HasValue)
                FragRemovalDate.DateValue = kit.Date_Fragment_Removal.Value.ToShortDateString();

            if (!String.IsNullOrEmpty(kit.Duty_Location_Injury_Occurred))
                FragILListBox.SelectedIndex = FragILListBox.Items.IndexOf(FragILListBox.Items.FindByText(kit.Duty_Location_Injury_Occurred));

            FragOtherLocationTextBox.Text = kit.Other_Location_Injury_Occurred;

            if (kit.Name_Referring_VAMC != null && kit.Name_Referring_VAMC.Length > 0)
                VAMCFacilityNameList.SelectedIndex = VAMCFacilityNameList.Items.IndexOf(VAMCFacilityNameList.Items.FindByText(kit.Name_Referring_VAMC));

            VAMCFragAddress1TextBox.Text = kit.Referring_VAMC_Street_Address1;
            VAMCFragAddress2TextBox.Text = kit.Referring_VAMC_Street_Address2;
            VAMCFragAddress3TextBox.Text = kit.Referring_VAMC_Street_Address3;
            VAMCFragCityTextBox.Text = kit.Referring_VAMC_City;
            VAMCFragStateTextBox.Text = kit.Referring_VAMC_State;
            VAMCFragZipTextBox.Text = kit.Referring_VAMC_PostalCode;
            VAMCFragZip4TextBox.Text = kit.Referring_VAMC_ZipPlus4;
            VAMCFragMailStopTextBox.Text = kit.Referring_VAMC_MailCode;

            SurgeonTextBox.Text = kit.Referring_Provider_Name;
            SurgeonPagerTextBox.Text = kit.Provider_Pager_Number;
            SurgeonPhoneTextBox.Text = kit.Provider_Telephone_Number;
            SurgeonFaxTextBox.Text = kit.Provider_Fax_Number;

            FacilityContactNameTextBox.Text = kit.Referring_Facility_Contact_Name;
            FacilityContactPhoneTextBox.Text = kit.Referring_Facility_Contact_Phone;
        }

        private void SetupSavedOrCompleteSurvey(VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            if (!String.IsNullOrEmpty(kit.VAMC_Name))
                VAMCFAcilityNamesListBox.SelectedIndex = VAMCFAcilityNamesListBox.Items.IndexOf(VAMCFAcilityNamesListBox.Items.FindByText(kit.VAMC_Name));
            else
                VAMCFAcilityNamesListBox.SelectedIndex = 0;

            VAMCAddress1TextBox.Text = kit.VAMC_Street_Address1;
            VAMCAddress2TextBox.Text = kit.VAMC_Street_Address2;
            VAMCAddress3TextBox.Text = kit.VAMC_Street_Address3;
            VAMCCityTextBox.Text = kit.VAMC_City;
            VAMCStateTextBox.Text = kit.VAMC_State;
            VAMCZipTextBox.Text = kit.VAMC_PostalCiode;
            VAMCZip4TextBox.Text = kit.VAMC_ZipPlus4;

            if (kit.Form_Complete_Date.HasValue)
            {
                CompletionDateBox.Text = kit.Form_Complete_Date.Value.ToShortDateString();
            }

            if (kit.BRANCH_OF_SERVICE_AIRFORCE == true)
                SBNamesListBox.Items.FindByValue("Air Force").Selected = true;
            if (kit.BRANCH_OF_SERVICE_ARMY == true)
                SBNamesListBox.Items.FindByValue("Army").Selected = true;
            if (kit.BRANCH_OF_SERVICE_MARINES == true)
                SBNamesListBox.Items.FindByValue("Marine Corps").Selected = true;
            if (kit.BRANCH_OF_SERVICE_NATIONALGUARD == true)
                SBNamesListBox.Items.FindByValue("National Guard").Selected = true;
            if (kit.BRANCH_OF_SERVICE_NAVY == true)
                SBNamesListBox.Items.FindByValue("Navy").Selected = true;
            if (kit.BRANCH_OF_SERVICE_RESERVE == true)
                SBNamesListBox.Items.FindByValue("Reserve").Selected = true;

            if (kit.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN == true)
                CheckBoxAfghanistan.Checked = true;

            if (kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ == true)
                CheckBoxIraq.Checked = true;

            TextBoxIraqCity.Text = kit.Injury_City;

            if (kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION == true)
                CheckBoxOtherCity.Checked = true;

            TextBoxOtherCity.Text = kit.Injury_Geographical_Location_other;

            if (kit.Injury_Day.HasValue)
            {
                if (kit.Injury_Day.Value > 0)
                    DaysListBox.SelectedValue = kit.Injury_Day.Value.ToString();
                else
                    DaysListBox.SelectedIndex = 0;
            }

            if (kit.Injury_Month.HasValue)
            {
                if (kit.Injury_Month.Value > 0)
                    MonthsListBox.SelectedValue = kit.Injury_Month.Value.ToString();
                else
                    MonthsListBox.SelectedIndex = 0;
            }

            if (kit.Injury_Year.HasValue)
            {
                InjuryYearTextBox.Text = kit.Injury_Year.Value.ToString();
            }

            //display indicators
            if (kit.Bullet_Injury_Ind.HasValue)
                BulletInjuryButtonList.SelectedIndex = BulletInjuryButtonList.Items.IndexOf(BulletInjuryButtonList.Items.FindByValue(kit.Bullet_Injury_Ind.Value.ToString()));

            if (kit.Blast_Explosion_Ind.HasValue)
                BlastExplosionButtonList.SelectedIndex = BlastExplosionButtonList.Items.IndexOf(BlastExplosionButtonList.Items.FindByValue(kit.Blast_Explosion_Ind.Value.ToString()));

            DistanceTextBox.Text = kit.Distance_from_Explosion_Meter;

            if (kit.Injured_on_Vehicle_Ind.HasValue)
                VehicleInjuryButtonList.SelectedIndex = VehicleInjuryButtonList.Items.IndexOf(VehicleInjuryButtonList.Items.FindByValue(kit.Injured_on_Vehicle_Ind.Value.ToString()));

            OtherSourceTextBox.Text = kit.Injured_by_OtherSource_Desc;

            if (kit.Shrapnel_Frag_Bullet_Surgery_Ind.HasValue)
                SurgeryButtonList.SelectedIndex = SurgeryButtonList.Items.IndexOf(SurgeryButtonList.Items.FindByValue(kit.Shrapnel_Frag_Bullet_Surgery_Ind.Value.ToString()));

            if (kit.Send_to_Lab_Analysis_Ind.HasValue)
                AnalysisButtonList.SelectedIndex = AnalysisButtonList.Items.IndexOf(AnalysisButtonList.Items.FindByValue(kit.Send_to_Lab_Analysis_Ind.Value.ToString()));

            if (kit.Fragment_Remains_inPatient_Ind.HasValue)
                FragmentButtonList.SelectedIndex = FragmentButtonList.Items.IndexOf(FragmentButtonList.Items.FindByValue(kit.Fragment_Remains_inPatient_Ind.Value.ToString()));

            CheckBoxInField.Checked = kit.TREATLOCAT_FIELD;
            TextBoxInTheField.Text = kit.TREATLOCAT_FIELD_Where;
            CheckBoxCombatHospital.Checked = kit.TREATLOCAT_SUPPORTHOSP;
            TextBoxCombatHospital.Text = kit.TREATLOCAT_SUPPORTHOSP_Where;
            CheckBoxGermany.Checked = kit.TREATLOCAT_GERMANY;
            CheckBoxUSFacility.Checked = kit.TREATLOCAT_FACILITY;
            TextBoxUSFacility.Text = kit.TREATLOCAT_FACILITY_Where;
            CheckBoxVAMedicalCenter.Checked = kit.TREATLOCAT_MEDCENTER;
            TextBoxVAMedicalCenter.Text = kit.TREATLOCAT_MEDCENTER_Where;

            CheckBoxPastYearWelding.Checked = kit.PAST_YEAR_WELDING_FLAG ?? false;
            CheckBoxPastYearSoldering.Checked = kit.PAST_YEAR_SOLDERING_FLAG ?? false;
            CheckBoxPastYearSmelting.Checked = kit.PAST_YEAR_SMELTING_FLAG ?? false;
            CheckBoxPastYearMining.Checked = kit.PAST_YEAR_MINING_FLAG ?? false;
            CheckBoxPastYearDemolition.Checked = kit.PAST_YEAR_DEMOLITION_FLAG ?? false;
            CheckBoxPastYearSandBlasting.Checked = kit.PAST_YEAR_SAND_BLASTING_FLAG ?? false;
            CheckBoxPastYearMachining.Checked = kit.PAST_YEAR_MACHINING_FLAG ?? false;
            CheckBoxPastYearMining.Checked = kit.PAST_YEAR_MINING_FLAG ?? false;
            CheckBoxPastYearOtherManufacturing.Checked = kit.PAST_YEAR_OTHER_MANUFACTURING_FLAG ?? false;
            CheckBoxPastYearFiringRange.Checked = kit.PAST_YEAR_FIRING_RANGE_USE_FLAG ?? false;
            CheckBoxPastYearMakingBullets.Checked = kit.PAST_YEAR_MAKING_BULLETS_FLAG ?? false;
            CheckBoxPastYearNone.Checked = kit.PAST_YEAR_NOT_WORKED_IN_OCCUPATION_HOBBY_FLAG ?? false;
            CheckBoxPastYearLeadPaint.Checked = kit.PAST_YEAR_LEAD_PAINT_FLAG ?? false;
            CheckBoxPaseYearMarinePaint.Checked = kit.PAST_YEAR_ANTI_FOULANT_FLAG ?? false;
            CheckBoxPastYearPreservatives.Checked = kit.PAST_YEAR_WOOD_PRESERVATIVES_FLAG ?? false;
            CheckBoxPastYearFishingWeights.Checked = kit.PAST_YEAR_FISHING_WEIGHTS_FLAG ?? false;
            CheckBoxPastYearStainedGlass.Checked = kit.PAST_YEAR_STAINED_GLASS_FLAG ?? false;
            CheckBoxPastYearJewelry.Checked = kit.PAST_YEAR_JEWELRY_OR_ART_METALS_FLAG ?? false;

            if (kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG.HasValue)
                if ((bool)kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG)
                    RadioButtonListOccupationMetalDust.SelectedIndex = 0;
                else
                    RadioButtonListOccupationMetalDust.SelectedIndex = 1;
            else
                RadioButtonListOccupationMetalDust.SelectedIndex = 2;

            TextBoxOccupationRelatedToMetalDust.Text = kit.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC;

            if (kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG.HasValue)
                if ((bool)kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG)
                    RadioButtonListHobbyMetalDust.SelectedIndex = 0;
                else
                    RadioButtonListHobbyMetalDust.SelectedIndex = 1;
            else
                RadioButtonListHobbyMetalDust.SelectedIndex = 2;

            TextBoxHobbyRelatedToMetalDust.Text = kit.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC;

            // Implants
            CheckBoxPacemaker.Checked = kit.DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR_FLAG ?? false;
            CheckBoxStents.Checked = kit.DEVICE_IMPLANTED_STENTS_FLAG ?? false;
            CheckBoxSurgicalClips.Checked = kit.DEVICE_IMPLANTED_SURGICAL_CLIPS_FLAG ?? false;
            CheckBoxMetalPlates.Checked = kit.DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS_FLAG ?? false;
            CheckBoxDentalImplants.Checked = kit.DEVICE_IMPLANTED_DENTAL_IMPLANTS_FLAG ?? false;
            CheckBoxHipReplacements.Checked = kit.DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL_FLAG ?? false;
            CheckBoxOther.Checked = kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG ?? false;
            TextBoxOtherMetalImplants.Text = kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC;
            CheckBoxImplantsDoNotHave.Checked = kit.DEVICE_IMPLANTED_NONE_FLAG ?? false;

            TextBoxImplantsLocation1.Text = kit.DEVICE_IMPLANTED_LOCATION1;
            TextBoxImplantsLocation2.Text = kit.DEVICE_IMPLANTED_LOCATION2;
            TextBoxImplantsLocation3.Text = kit.DEVICE_IMPLANTED_LOCATION3;
            TextBoxImplantsLocation4.Text = kit.DEVICE_IMPLANTED_LOCATION4;

            TextBoxImplantsYear1.Text = kit.DEVICE_IMPLANTED_YEAR1;
            TextBoxImplantsYear2.Text = kit.DEVICE_IMPLANTED_YEAR2;
            TextBoxImplantsYear3.Text = kit.DEVICE_IMPLANTED_YEAR3;
            TextBoxImplantsYear4.Text = kit.DEVICE_IMPLANTED_YEAR4;

            // Do you have and do you use

            CheckBoxMetalBraces.Checked = kit.HAVE_METAL_TEETH_BRACES_FLAG ?? false;
            CheckBoxPiercings.Checked = kit.HAVE_PIERCINGS_FLAG ?? false;
            CheckBoxTattoos.Checked = kit.HAVE_TATOOS_FLAG ?? false;
            CheckBoxNoTatoos.Checked = kit.HAVE_NONE_ABOVE_FLAG ?? false;

            CheckBoxZinc.Checked = kit.ROUTINELY_USE_ZINC_SUNBLOCK_FLAG ?? false;
            CheckBoxSupplements.Checked = kit.ROUTINELY_USE_DIETARY_SUPPLEMENTS_FLAG ?? false;
            CheckBoxVitamins.Checked = kit.ROUTINELY_USE_VITAMINS_FLAG ?? false;
            CheckBoxAyurvedic.Checked = kit.ROUTINELY_USE_AYURVEDIC_MEDS_FLAG ?? false;
            CheckBoxDenture.Checked = kit.ROUTINELY_USE_DENTURE_CREAM_FLAG ?? false;
            CheckBoxNoDrugs.Checked = kit.ROUTINELY_USE_NONE_ABOVE_FLAG ?? false;

            // Other Factors

            if (kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG.HasValue)
            {
                if ((bool)kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG)
                    RadioButtonListWaterSource.SelectedIndex = 0;
            }
            if (kit.PRIMARY_WATER_PRIVATE_WELL_FLAG.HasValue)
            {
                if ((bool)kit.PRIMARY_WATER_PRIVATE_WELL_FLAG)
                    RadioButtonListWaterSource.SelectedIndex = 1;
            }
            else
            {
                RadioButtonListWaterSource.SelectedIndex = 2;
            }

            if (kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG.HasValue)
            {
                if ((bool)kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG)
                    RadioButtonListSmoke.SelectedIndex = 0;
                else
                    RadioButtonListSmoke.SelectedIndex = 1;
            }

            if (kit.CURRENTLY_CHEW_TOBACCO_FLAG.HasValue)
            {
                if ((bool)kit.CURRENTLY_CHEW_TOBACCO_FLAG)
                    RadioButtonListChewTobacco.SelectedIndex = 0;
                else
                    RadioButtonListChewTobacco.SelectedIndex = 1;
            }
        }

        private void SetupExplosionCause(VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            if (kit.Injured_by_IED_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("0").Selected = kit.Injured_by_IED_FLAG.Value;
            }

            if (kit.Injured_by_RPG_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("1").Selected = kit.Injured_by_RPG_FLAG.Value;
            }

            if (kit.Injured_by_LandMine_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("2").Selected = kit.Injured_by_LandMine_FLAG.Value;
            }

            if (kit.Injured_by_Grenade_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("3").Selected = kit.Injured_by_Grenade_FLAG.Value;
            }

            if (kit.Injured_by_EnemyFire_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("4").Selected = kit.Injured_by_EnemyFire_FLAG.Value;
            }

            if (kit.Injured_by_FriendlyFire_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("5").Selected = kit.Injured_by_FriendlyFire_FLAG.Value;
            }

            if (kit.Injured_by_UnknownSource_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("6").Selected = kit.Injured_by_UnknownSource_FLAG.Value;
            }

            if (kit.Injured_by_OtherSource_FLAG.HasValue)
            {
                CheckBoxExplosionCauses.Items.FindByValue("7").Selected = kit.Injured_by_OtherSource_FLAG.Value;
            }
        }

        private void SaveExplosionCause(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit, bool saveValues)
        {
            kit.Injured_by_IED_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("0").Selected : false;
            kit.Injured_by_RPG_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("1").Selected : false;
            kit.Injured_by_LandMine_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("2").Selected : false;
            kit.Injured_by_Grenade_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("3").Selected : false;
            kit.Injured_by_EnemyFire_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("4").Selected : false;
            kit.Injured_by_FriendlyFire_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("5").Selected : false;
            kit.Injured_by_UnknownSource_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("6").Selected : false;
            kit.Injured_by_OtherSource_FLAG = saveValues ? CheckBoxExplosionCauses.Items.FindByValue("7").Selected : false;

            if (saveValues && CheckBoxExplosionCauses.Items.FindByValue("7").Selected)
                kit.Injured_by_OtherSource_Desc = OtherSourceTextBox.Text.Trim();
            else
                kit.Injured_by_OtherSource_Desc = "";
        }

        private void SetupBodyPartsCheckList(VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            ListItem item = BodyPartsList.Items.FindByValue("0");
            item.Selected = kit.Injury_Back_Head.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("1");
            item.Selected = kit.Injury_Back_Neck.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("2");
            item.Selected = kit.Injury_Upper_Back.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("3");
            item.Selected = kit.Injury_Lower_Back.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("4");
            item.Selected = kit.Injury_Buttocks.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("5");
            item.Selected = kit.Injury_Front_Head.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("6");
            item.Selected = kit.Injury_Front_Neck.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("7");
            item.Selected = kit.Injury_Chest.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("8");
            item.Selected = kit.Injury_Abdomen.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("9");
            item.Selected = kit.Injury_Groin_Pelvis.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("10");
            item.Selected = kit.Injury_Left_Shoulder.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("11");
            item.Selected = kit.Injury_Left_Upper_Arm.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("12");
            item.Selected = kit.Injury_Left_Hand_Wrist_Fingers.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("13");
            item.Selected = kit.Injury_Left_Upper_Leg_Thigh.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("14");
            item.Selected = kit.Injury_Left_Knee.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("15");
            item.Selected = kit.Injury_Left_Lower_Leg.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("16");
            item.Selected = kit.Injury_Left_Ankle.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("17");
            item.Selected = kit.Injury_Left_Foot_Toes.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("18");
            item.Selected = kit.Injury_Right_Shoulder.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("19");
            item.Selected = kit.Injury_Right_Upper_Arm.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("20");
            item.Selected = kit.Injury_Right_Lower_Arm.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("21");
            item.Selected = kit.Injury_Right_Hand_Wrist_Fingers.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("22");
            item.Selected = kit.Injury_Right_Upper_Leg_Thigh.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("23");
            item.Selected = kit.Injury_Right_Knee.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("24");
            item.Selected = kit.Injury_Right_Lower_Leg.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("25");
            item.Selected = kit.Injury_Right_Ankle.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("26");
            item.Selected = kit.Injury_Right_Foot_Toes.GetValueOrDefault();

            item = BodyPartsList.Items.FindByValue("27");
            item.Selected = kit.Injury_Left_Lower_Arm.GetValueOrDefault();
        }

        private void SetupBodyFragmentsCheckList(VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            ListItem item = FragmentLocationsList.Items.FindByValue("0");
            item.Selected = kit.Remain_in_Back_Head.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("1");
            item.Selected = kit.Remain_in_Back_Neck.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("2");
            item.Selected = kit.Remain_in_Upper_Back.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("3");
            item.Selected = kit.Remain_in_Lower_Back.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("4");
            item.Selected = kit.Remain_in_Buttocks.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("5");
            item.Selected = kit.Remain_in_Front_Head.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("6");
            item.Selected = kit.Remain_in_Front_Neck.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("7");
            item.Selected = kit.Remain_in_Chest.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("8");
            item.Selected = kit.Remain_in_Abdomen.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("9");
            item.Selected = kit.Remain_in_Groin_Pelvis.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("10");
            item.Selected = kit.Remain_in_Left_Shoulder.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("11");
            item.Selected = kit.Remain_in_Left_Upper_Arm.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("12");
            item.Selected = kit.Remain_in_Left_Hand_Wrist_Fingers.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("13");
            item.Selected = kit.Remain_in_Left_Upper_Leg_Thigh.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("14");
            item.Selected = kit.Remain_in_Left_Knee.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("15");
            item.Selected = kit.Remain_in_Left_Lower_Leg.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("16");
            item.Selected = kit.Remain_in_Left_Ankle.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("17");
            item.Selected = kit.Remain_in_Left_Foot_Toes.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("18");
            item.Selected = kit.Remain_in_Right_Shoulder.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("19");
            item.Selected = kit.Remain_in_Right_Upper_Arm.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("20");
            item.Selected = kit.Remain_in_Right_Lower_Arm.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("21");
            item.Selected = kit.Remain_in_Right_Hand_Wrist_Fingers.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("22");
            item.Selected = kit.Remain_in_Right_Upper_Leg_Thigh.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("23");
            item.Selected = kit.Remain_in_Right_Knee.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("24");
            item.Selected = kit.Remain_in_Right_Lower_Leg.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("25");
            item.Selected = kit.Remain_in_Right_Ankle.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("26");
            item.Selected = kit.Remain_in_Right_Foot_Toes.GetValueOrDefault();

            item = FragmentLocationsList.Items.FindByValue("27");
            item.Selected = kit.Remain_in_Left_Lower_Arm.GetValueOrDefault();
        }

        private void SetupSaveFragQuestionnaire(ref QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM kit)
        {
            kit.Fragment_1_Location = Frag1LocationTextBox.Text.Trim();
            kit.Fragment_2_Location = Frag2LocationTextBox.Text.Trim();
            kit.Fragment_3_Location = Frag3LocationTextBox.Text.Trim();

            kit.Date_Fragment_Removal = QuestionnnaireManager.ConvertStringToNullable<DateTime>(FragRemovalDate.DateValue.Trim());

            if (FragILListBox.SelectedIndex > 0)
                kit.Duty_Location_Injury_Occurred = FragILListBox.SelectedItem.Text.Trim();

            kit.Other_Location_Injury_Occurred = FragOtherLocationTextBox.Text.Trim();

            kit.Name_Referring_VAMC = VAMCFacilityNameList.SelectedItem.Text;
            kit.Referring_VAMC_Street_Address1 = VAMCFragAddress1TextBox.Text.Trim();
            kit.Referring_VAMC_Street_Address2 = VAMCFragAddress2TextBox.Text.Trim();
            kit.Referring_VAMC_Street_Address3 = VAMCFragAddress3TextBox.Text.Trim();
            kit.Referring_VAMC_City = VAMCFragCityTextBox.Text.Trim();
            kit.Referring_VAMC_State = VAMCFragStateTextBox.Text.Trim();
            kit.Referring_VAMC_PostalCode = VAMCFragZipTextBox.Text.Trim();
            kit.Referring_VAMC_ZipPlus4 = VAMCFragZip4TextBox.Text.Trim();
            kit.Referring_VAMC_MailCode = VAMCFragMailStopTextBox.Text.Trim();

            kit.Referring_Provider_Name = SurgeonTextBox.Text.Trim();
            kit.Provider_Pager_Number = SurgeonPagerTextBox.Text.Trim();
            kit.Provider_Telephone_Number = SurgeonPhoneTextBox.Text.Trim();
            kit.Provider_Fax_Number = SurgeonFaxTextBox.Text.Trim();

            kit.Referring_Facility_Contact_Name = FacilityContactNameTextBox.Text.Trim();
            kit.Referring_Facility_Contact_Phone = FacilityContactPhoneTextBox.Text.Trim();
            kit.UPDATED = DateTime.Now;
            kit.UPDATEDBY = userId;
        }

        private void SetupSaveQuestionnaire(ref QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            if (kit.CREATED < DateTime.Parse("01/01/1900"))
            {
                kit.CREATED = DateTime.Now;
            }
            if (kit.CREATEDBY == null)
            {
                kit.CREATEDBY = userId;
            }
            if (VAMCFAcilityNamesListBox.SelectedIndex > 0)
                kit.VAMC_Name = VAMCFAcilityNamesListBox.SelectedItem.Text;
            else
                kit.VAMC_Name = "";

            kit.VAMC_Street_Address1 = VAMCAddress1TextBox.Text.Trim();
            kit.VAMC_Street_Address2 = VAMCAddress2TextBox.Text.Trim();
            kit.VAMC_Street_Address3 = VAMCAddress3TextBox.Text.Trim();
            kit.VAMC_City = VAMCCityTextBox.Text.Trim();
            kit.VAMC_State = VAMCStateTextBox.Text.Trim();
            kit.VAMC_PostalCiode = VAMCZipTextBox.Text.Trim();
            kit.VAMC_ZipPlus4 = VAMCZip4TextBox.Text.Trim();

            kit.Form_Complete_Date = QuestionnnaireManager.ConvertStringToNullable<DateTime>(CompletionDateBox.Text);

            kit.BRANCH_OF_SERVICE_AIRFORCE = SBNamesListBox.Items.FindByValue("Air Force").Selected;
            kit.BRANCH_OF_SERVICE_ARMY = SBNamesListBox.Items.FindByValue("Army").Selected;
            kit.BRANCH_OF_SERVICE_MARINES = SBNamesListBox.Items.FindByValue("Marine Corps").Selected;
            kit.BRANCH_OF_SERVICE_NATIONALGUARD = SBNamesListBox.Items.FindByValue("National Guard").Selected;
            kit.BRANCH_OF_SERVICE_NAVY = SBNamesListBox.Items.FindByValue("Navy").Selected;
            kit.BRANCH_OF_SERVICE_RESERVE = SBNamesListBox.Items.FindByValue("Reserve").Selected;

            kit.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN = CheckBoxAfghanistan.Checked;

            kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ = CheckBoxIraq.Checked;
            kit.Injury_City = CheckBoxIraq.Checked ? TextBoxIraqCity.Text : "";

            kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION = CheckBoxOtherCity.Checked;
            kit.Injury_Geographical_Location_other = CheckBoxOtherCity.Checked ? TextBoxOtherCity.Text.Trim() : "";

            kit.Injury_Day = QuestionnnaireManager.ConvertStringToNullable<int>(DaysListBox.SelectedValue);
            kit.Injury_Month = QuestionnnaireManager.ConvertStringToNullable<int>(MonthsListBox.SelectedValue);
            kit.Injury_Year = QuestionnnaireManager.ConvertStringToNullable<int>(InjuryYearTextBox.Text.Trim());

            //save indicators if they set in the UI

            if (BulletInjuryButtonList.SelectedIndex > -1)
                kit.Bullet_Injury_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(BulletInjuryButtonList.SelectedValue);

            if (BlastExplosionButtonList.SelectedIndex == 0)
            {
                kit.Blast_Explosion_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(BlastExplosionButtonList.SelectedValue);
                kit.Distance_from_Explosion_Meter = DistanceTextBox.Text.Trim();

                if (VehicleInjuryButtonList.SelectedIndex > -1)
                    kit.Injured_on_Vehicle_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(VehicleInjuryButtonList.SelectedValue);

                SaveExplosionCause(kit, true);
            }
            else
            {
                if (BlastExplosionButtonList.SelectedIndex > -1)
                    kit.Blast_Explosion_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(BlastExplosionButtonList.SelectedValue);
                else
                    kit.Blast_Explosion_Ind = 'R';

                kit.Distance_from_Explosion_Meter = "";
                kit.Injured_on_Vehicle_Ind = 'R';

                SaveExplosionCause(kit, false);
            }

            if (SurgeryButtonList.SelectedIndex == 0)  // Yes
            {
                kit.Shrapnel_Frag_Bullet_Surgery_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(SurgeryButtonList.SelectedValue);

                if (AnalysisButtonList.SelectedIndex > -1) // Set if there's a selection, otherwise set to Not Recorded
                    kit.Send_to_Lab_Analysis_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(AnalysisButtonList.SelectedValue);
                else
                    kit.Send_to_Lab_Analysis_Ind = 'R';
            }
            else
            {
                if (SurgeryButtonList.SelectedIndex > -1)
                    kit.Shrapnel_Frag_Bullet_Surgery_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(SurgeryButtonList.SelectedValue);
                else
                    kit.Shrapnel_Frag_Bullet_Surgery_Ind = 'R';

                // Since the prev selection isn't Yes, set this to Not Recorded
                kit.Send_to_Lab_Analysis_Ind = 'R';
            }

            if (FragmentButtonList.SelectedValue == "Y")
            {
                kit.Fragment_Remains_inPatient_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(FragmentButtonList.SelectedValue);
                SaveFragments(kit, true);
            }
            else
            {
                if (FragmentButtonList.SelectedIndex > -1)
                    kit.Fragment_Remains_inPatient_Ind = QuestionnnaireManager.ConvertStringToNullable<char>(FragmentButtonList.SelectedValue);
                SaveFragments(kit, false);
            }

            // Always set the 2012 form indicator when saving this version

            kit.FORM_2012_FLAG = true;
            kit.FORM_2009_FLAG = false;

            kit.UPDATED = DateTime.Now;
            kit.UPDATEDBY = userId;

            //some more indicators

            SaveBodyParts(kit);
            SaveTreatmentFacilities(kit);
            SaveOccupationHobby(kit);
            SaveImplants(kit);
            SaveDoYouHaveAndDoYouUse(kit);
            SaveOtherFactors(kit);
        }

        private void SaveTreatmentFacilities(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            kit.TREATLOCAT_FIELD = CheckBoxInField.Checked;
            kit.TREATLOCAT_FIELD_Where = CheckBoxInField.Checked ? TextBoxInTheField.Text.Trim() : "";

            kit.TREATLOCAT_SUPPORTHOSP = CheckBoxCombatHospital.Checked;
            kit.TREATLOCAT_SUPPORTHOSP_Where = CheckBoxCombatHospital.Checked ? TextBoxCombatHospital.Text.Trim() : "";

            kit.TREATLOCAT_GERMANY = CheckBoxGermany.Checked;

            kit.TREATLOCAT_FACILITY = CheckBoxUSFacility.Checked;
            kit.TREATLOCAT_FACILITY_Where = CheckBoxUSFacility.Checked ? TextBoxUSFacility.Text.Trim() : "";

            kit.TREATLOCAT_MEDCENTER = CheckBoxVAMedicalCenter.Checked;
            kit.TREATLOCAT_MEDCENTER_Where = CheckBoxVAMedicalCenter.Checked ? TextBoxVAMedicalCenter.Text.Trim() : "";
        }

        private void SaveBodyParts(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            ListItem item = BodyPartsList.Items.FindByValue("0");
            kit.Injury_Back_Head = item.Selected;

            item = BodyPartsList.Items.FindByValue("1");
            kit.Injury_Back_Neck = item.Selected;

            item = BodyPartsList.Items.FindByValue("2");
            kit.Injury_Upper_Back = item.Selected;

            item = BodyPartsList.Items.FindByValue("3");
            kit.Injury_Lower_Back = item.Selected;

            item = BodyPartsList.Items.FindByValue("4");
            kit.Injury_Buttocks = item.Selected;

            item = BodyPartsList.Items.FindByValue("5");
            kit.Injury_Front_Head = item.Selected;

            item = BodyPartsList.Items.FindByValue("6");
            kit.Injury_Front_Neck = item.Selected;

            item = BodyPartsList.Items.FindByValue("7");
            kit.Injury_Chest = item.Selected;

            item = BodyPartsList.Items.FindByValue("8");
            kit.Injury_Abdomen = item.Selected;

            item = BodyPartsList.Items.FindByValue("9");
            kit.Injury_Groin_Pelvis = item.Selected;

            item = BodyPartsList.Items.FindByValue("10");
            kit.Injury_Left_Shoulder = item.Selected;

            item = BodyPartsList.Items.FindByValue("11");
            kit.Injury_Left_Upper_Arm = item.Selected;

            item = BodyPartsList.Items.FindByValue("12");
            kit.Injury_Left_Hand_Wrist_Fingers = item.Selected;

            item = BodyPartsList.Items.FindByValue("13");
            kit.Injury_Left_Upper_Leg_Thigh = item.Selected;

            item = BodyPartsList.Items.FindByValue("14");
            kit.Injury_Left_Knee = item.Selected;

            item = BodyPartsList.Items.FindByValue("15");
            kit.Injury_Left_Lower_Leg = item.Selected;

            item = BodyPartsList.Items.FindByValue("16");
            kit.Injury_Left_Ankle = item.Selected;

            item = BodyPartsList.Items.FindByValue("17");
            kit.Injury_Left_Foot_Toes = item.Selected;

            item = BodyPartsList.Items.FindByValue("18");
            kit.Injury_Right_Shoulder = item.Selected;

            item = BodyPartsList.Items.FindByValue("19");
            kit.Injury_Right_Upper_Arm = item.Selected;

            item = BodyPartsList.Items.FindByValue("20");
            kit.Injury_Right_Lower_Arm = item.Selected;

            item = BodyPartsList.Items.FindByValue("21");
            kit.Injury_Right_Hand_Wrist_Fingers = item.Selected;

            item = BodyPartsList.Items.FindByValue("22");
            kit.Injury_Right_Upper_Leg_Thigh = item.Selected;

            item = BodyPartsList.Items.FindByValue("23");
            kit.Injury_Right_Knee = item.Selected;

            item = BodyPartsList.Items.FindByValue("24");
            kit.Injury_Right_Lower_Leg = item.Selected;

            item = BodyPartsList.Items.FindByValue("25");
            kit.Injury_Right_Ankle = item.Selected;

            item = BodyPartsList.Items.FindByValue("26");
            kit.Injury_Right_Foot_Toes = item.Selected;

            item = BodyPartsList.Items.FindByValue("27");
            kit.Injury_Left_Lower_Arm = item.Selected;
        }

        private void SaveFragments(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit, bool saveValues)
        {
            if (saveValues)
            {
                ListItem item = FragmentLocationsList.Items.FindByValue("0");
                kit.Remain_in_Back_Head = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("1");
                kit.Remain_in_Back_Neck = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("2");
                kit.Remain_in_Upper_Back = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("3");
                kit.Remain_in_Lower_Back = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("4");
                kit.Remain_in_Buttocks = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("5");
                kit.Remain_in_Front_Head = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("6");
                kit.Remain_in_Front_Neck = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("7");
                kit.Remain_in_Chest = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("8");
                kit.Remain_in_Abdomen = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("9");
                kit.Remain_in_Groin_Pelvis = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("10");
                kit.Remain_in_Left_Shoulder = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("11");
                kit.Remain_in_Left_Upper_Arm = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("12");
                kit.Remain_in_Left_Hand_Wrist_Fingers = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("13");
                kit.Remain_in_Left_Upper_Leg_Thigh = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("14");
                kit.Remain_in_Left_Knee = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("15");
                kit.Remain_in_Left_Lower_Leg = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("16");
                kit.Remain_in_Left_Ankle = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("17");
                kit.Remain_in_Left_Foot_Toes = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("18");
                kit.Remain_in_Right_Shoulder = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("19");
                kit.Remain_in_Right_Upper_Arm = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("20");
                kit.Remain_in_Right_Lower_Arm = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("21");
                kit.Remain_in_Right_Hand_Wrist_Fingers = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("22");
                kit.Remain_in_Right_Upper_Leg_Thigh = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("23");
                kit.Remain_in_Right_Knee = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("24");
                kit.Remain_in_Right_Lower_Leg = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("25");
                kit.Remain_in_Right_Ankle = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("26");
                kit.Remain_in_Right_Foot_Toes = item.Selected;

                item = FragmentLocationsList.Items.FindByValue("27");
                kit.Remain_in_Left_Lower_Arm = item.Selected;
            }
            else
            {
                kit.Remain_in_Back_Head = false;
                kit.Remain_in_Back_Neck = false;
                kit.Remain_in_Upper_Back = false;
                kit.Remain_in_Lower_Back = false;
                kit.Remain_in_Buttocks = false;
                kit.Remain_in_Front_Head = false;
                kit.Remain_in_Front_Neck = false;
                kit.Remain_in_Chest = false;
                kit.Remain_in_Abdomen = false;
                kit.Remain_in_Groin_Pelvis = false;
                kit.Remain_in_Left_Shoulder = false;
                kit.Remain_in_Left_Upper_Arm = false;
                kit.Remain_in_Left_Hand_Wrist_Fingers = false;
                kit.Remain_in_Left_Upper_Leg_Thigh = false;
                kit.Remain_in_Left_Knee = false;
                kit.Remain_in_Left_Lower_Leg = false;
                kit.Remain_in_Left_Ankle = false;
                kit.Remain_in_Left_Foot_Toes = false;
                kit.Remain_in_Right_Shoulder = false;
                kit.Remain_in_Right_Upper_Arm = false;
                kit.Remain_in_Right_Lower_Arm = false;
                kit.Remain_in_Right_Hand_Wrist_Fingers = false;
                kit.Remain_in_Right_Upper_Leg_Thigh = false;
                kit.Remain_in_Right_Knee = false;
                kit.Remain_in_Right_Lower_Leg = false;
                kit.Remain_in_Right_Ankle = false;
                kit.Remain_in_Right_Foot_Toes = false;
                kit.Remain_in_Left_Lower_Arm = false;
            }
        }

        private void SaveOccupationHobby(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            kit.PAST_YEAR_NOT_WORKED_IN_OCCUPATION_HOBBY_FLAG = CheckBoxPastYearNone.Checked;
            kit.PAST_YEAR_WELDING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearWelding.Checked : false;
            kit.PAST_YEAR_SOLDERING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearSoldering.Checked : false;
            kit.PAST_YEAR_SMELTING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearSmelting.Checked : false;
            kit.PAST_YEAR_MINING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearMining.Checked : false;
            kit.PAST_YEAR_DEMOLITION_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearDemolition.Checked : false;
            kit.PAST_YEAR_SAND_BLASTING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearSandBlasting.Checked : false;
            kit.PAST_YEAR_MACHINING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearMachining.Checked : false;
            kit.PAST_YEAR_OTHER_MANUFACTURING_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearOtherManufacturing.Checked : false;
            kit.PAST_YEAR_FIRING_RANGE_USE_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearFiringRange.Checked : false;
            kit.PAST_YEAR_MAKING_BULLETS_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearMakingBullets.Checked : false;
            kit.PAST_YEAR_LEAD_PAINT_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearLeadPaint.Checked : false;
            kit.PAST_YEAR_ANTI_FOULANT_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPaseYearMarinePaint.Checked : false;
            kit.PAST_YEAR_WOOD_PRESERVATIVES_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearPreservatives.Checked : false;
            kit.PAST_YEAR_FISHING_WEIGHTS_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearFishingWeights.Checked : false;
            kit.PAST_YEAR_STAINED_GLASS_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearStainedGlass.Checked : false;
            kit.PAST_YEAR_JEWELRY_OR_ART_METALS_FLAG = !CheckBoxPastYearNone.Checked ? CheckBoxPastYearJewelry.Checked : false;

            switch (RadioButtonListOccupationMetalDust.SelectedIndex)
            {
                case -1:
                    kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG = null;
                    kit.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC = "";
                    break;
                case 0:
                    kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG = true;
                    kit.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC = TextBoxOccupationRelatedToMetalDust.Text.Trim();
                    break;
                case 1:
                    kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG = false;
                    kit.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC = "";
                    break;
                case 2:
                    kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG = null;
                    kit.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC = "";
                    break;
            }

            switch (RadioButtonListHobbyMetalDust.SelectedIndex)
            {
                case -1:
                    kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG = null;
                    kit.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC = "";
                    break;
                case 0:
                    kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG = true;
                    kit.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC = TextBoxHobbyRelatedToMetalDust.Text.Trim();
                    break;
                case 1:
                    kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG = false;
                    kit.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC = "";
                    break;
                case 2:
                    kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG = null;
                    kit.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC = "";
                    break;
            }
        }

        private void SaveImplants(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            if (!CheckBoxImplantsDoNotHave.Checked)
            {
                kit.DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR_FLAG = CheckBoxPacemaker.Checked;
                kit.DEVICE_IMPLANTED_STENTS_FLAG = CheckBoxStents.Checked;
                kit.DEVICE_IMPLANTED_SURGICAL_CLIPS_FLAG = CheckBoxSurgicalClips.Checked;
                kit.DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS_FLAG = CheckBoxMetalPlates.Checked;
                kit.DEVICE_IMPLANTED_DENTAL_IMPLANTS_FLAG = CheckBoxDentalImplants.Checked;
                kit.DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL_FLAG = CheckBoxHipReplacements.Checked;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG = CheckBoxOther.Checked;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC = CheckBoxOther.Checked ? TextBoxOtherMetalImplants.Text.Trim() : "";

                kit.DEVICE_IMPLANTED_NONE_FLAG = CheckBoxImplantsDoNotHave.Checked;

                kit.DEVICE_IMPLANTED_LOCATION1 = TextBoxImplantsLocation1.Text.Trim();
                kit.DEVICE_IMPLANTED_LOCATION2 = TextBoxImplantsLocation2.Text.Trim();
                kit.DEVICE_IMPLANTED_LOCATION3 = TextBoxImplantsLocation3.Text.Trim();
                kit.DEVICE_IMPLANTED_LOCATION4 = TextBoxImplantsLocation4.Text.Trim();

                kit.DEVICE_IMPLANTED_YEAR1 = TextBoxImplantsYear1.Text.Trim();
                kit.DEVICE_IMPLANTED_YEAR2 = TextBoxImplantsYear2.Text.Trim();
                kit.DEVICE_IMPLANTED_YEAR3 = TextBoxImplantsYear3.Text.Trim();
                kit.DEVICE_IMPLANTED_YEAR4 = TextBoxImplantsYear4.Text.Trim();
            }
            else
            {
                kit.DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR_FLAG = false;
                kit.DEVICE_IMPLANTED_STENTS_FLAG = false;
                kit.DEVICE_IMPLANTED_SURGICAL_CLIPS_FLAG = false;
                kit.DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS_FLAG = false;
                kit.DEVICE_IMPLANTED_DENTAL_IMPLANTS_FLAG = false;
                kit.DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL_FLAG = false;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG = false;
                kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC = "";

                kit.DEVICE_IMPLANTED_NONE_FLAG = CheckBoxImplantsDoNotHave.Checked;

                kit.DEVICE_IMPLANTED_LOCATION1 = "";
                kit.DEVICE_IMPLANTED_LOCATION2 = "";
                kit.DEVICE_IMPLANTED_LOCATION3 = "";
                kit.DEVICE_IMPLANTED_LOCATION4 = "";

                kit.DEVICE_IMPLANTED_YEAR1 = "";
                kit.DEVICE_IMPLANTED_YEAR2 = "";
                kit.DEVICE_IMPLANTED_YEAR3 = "";
                kit.DEVICE_IMPLANTED_YEAR4 = "";
            }
        }

        private void SaveDoYouHaveAndDoYouUse(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            kit.HAVE_NONE_ABOVE_FLAG = CheckBoxNoTatoos.Checked;
            kit.HAVE_METAL_TEETH_BRACES_FLAG = !CheckBoxNoTatoos.Checked ? CheckBoxMetalBraces.Checked : false;
            kit.HAVE_PIERCINGS_FLAG = !CheckBoxNoTatoos.Checked ? CheckBoxPiercings.Checked : false;
            kit.HAVE_TATOOS_FLAG = !CheckBoxNoTatoos.Checked ? CheckBoxTattoos.Checked : false;

            kit.ROUTINELY_USE_NONE_ABOVE_FLAG = CheckBoxNoDrugs.Checked;
            kit.ROUTINELY_USE_ZINC_SUNBLOCK_FLAG = !CheckBoxNoDrugs.Checked ? CheckBoxZinc.Checked : false;
            kit.ROUTINELY_USE_DIETARY_SUPPLEMENTS_FLAG = !CheckBoxNoDrugs.Checked ? CheckBoxSupplements.Checked : false;
            kit.ROUTINELY_USE_VITAMINS_FLAG = !CheckBoxNoDrugs.Checked ? CheckBoxVitamins.Checked : false;
            kit.ROUTINELY_USE_AYURVEDIC_MEDS_FLAG = !CheckBoxNoDrugs.Checked ? CheckBoxAyurvedic.Checked : false;
            kit.ROUTINELY_USE_DENTURE_CREAM_FLAG = !CheckBoxNoDrugs.Checked ? CheckBoxDenture.Checked : false;
        }

        private void SaveOtherFactors(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            switch (RadioButtonListWaterSource.SelectedIndex)
            {
                case -1:
                    kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG = null;
                    kit.PRIMARY_WATER_PRIVATE_WELL_FLAG = null;
                    break;
                case 0:
                    kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG = true;
                    kit.PRIMARY_WATER_PRIVATE_WELL_FLAG = false;
                    break;
                case 1:
                    kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG = false;
                    kit.PRIMARY_WATER_PRIVATE_WELL_FLAG = true;
                    break;
                case 2:
                    kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG = null;
                    kit.PRIMARY_WATER_PRIVATE_WELL_FLAG = null;
                    break;
            }

            switch (RadioButtonListSmoke.SelectedIndex)
            {
                case -1:
                    kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG = null;
                    break;
                case 0:
                    kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG = true;
                    break;
                case 1:
                    kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG = false;
                    break;
                case 2:
                    kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG = null;
                    break;
            }

            switch (RadioButtonListChewTobacco.SelectedIndex)
            {
                case -1:
                    kit.CURRENTLY_CHEW_TOBACCO_FLAG = null;
                    break;
                case 0:
                    kit.CURRENTLY_CHEW_TOBACCO_FLAG = true;
                    break;
                case 1:
                    kit.CURRENTLY_CHEW_TOBACCO_FLAG = false;
                    break;
                case 2:
                    kit.CURRENTLY_CHEW_TOBACCO_FLAG = null;
                    break;
            }
        }

        protected void DropDownDaysDataBound(object sender, EventArgs e)
        {
            DaysListBox.Items.Insert(0, new ListItem("(unknown)", "0"));
        }

        protected void DropDownMonthsDataBound(object sender, EventArgs e)
        {
            MonthsListBox.Items.Insert(0, new ListItem("(unknown)", "0"));
        }
    }
}
